/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.DownloadPanel;
import com.izforge.izpack.installer.WebAccessor;
import java.io.IOException;
import java.io.InputStream;

public class LoggedInputStream
extends InputStream {
    private long bytesRead = 0L;
    private InputStream is;
    private DownloadPanel downloader;
    private boolean cancelled = false;
    private long lastTime = -1L;
    private long lastBytes = -1L;

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public LoggedInputStream(InputStream inputStream, WebAccessor webAccessor) {
        if (inputStream == null) {
            throw new RuntimeException("Unable to connect");
        }
        this.is = inputStream;
        String string = webAccessor.getContentLength() > 0 ? "(" + Pack.toByteUnitsString(webAccessor.getContentLength()) + ")" : "";
        this.downloader = new DownloadPanel(this);
        this.downloader.setTitle("Downloading");
        this.downloader.setFileLabel(webAccessor.getUrl() + " " + string);
        this.downloader.setLocationRelativeTo(null);
        this.downloader.setVisible(true);
        if (webAccessor.getContentLength() > 0) {
            this.downloader.setProgressMax(webAccessor.getContentLength());
            this.downloader.setProgressCurrent(0);
        }
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.downloader.setVisible(false);
        this.downloader.dispose();
        this.is.close();
    }

    public synchronized void mark(int n) {
        this.is.mark(n);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is.read(byArray, n, n2);
        if (n3 > 0) {
            this.bytesRead += (long)n3;
        }
        this.update();
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.is.read(byArray);
        if (n > 0) {
            this.bytesRead += (long)n;
        }
        this.update();
        return n;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public int read() throws IOException {
        int n = this.is.read();
        if (n > 0) {
            ++this.bytesRead;
        }
        this.update();
        return n;
    }

    private void update() {
        if (this.lastTime > 0L) {
            long l = System.currentTimeMillis();
            long l2 = l - this.lastTime;
            if (l2 > 800L) {
                double d = (double)(this.bytesRead - this.lastBytes) / ((double)l2 / 1000.0);
                this.downloader.setStatusLabel(Pack.toByteUnitsString(Math.round(d)) + "/s");
                this.lastTime = l;
                this.lastBytes = this.bytesRead;
            }
        } else {
            this.lastTime = System.currentTimeMillis();
            this.lastBytes = this.bytesRead;
        }
        this.downloader.setProgressCurrent((int)this.bytesRead);
        if (this.cancelled) {
            throw new RuntimeException("Cancelled");
        }
    }
}

