/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;

public class AndCondition
extends Condition {
    private static final long serialVersionUID = -5854944262991488370L;
    protected Condition leftoperand;
    protected Condition rightoperand;

    public AndCondition() {
    }

    public AndCondition(Condition condition, Condition condition2, AutomatedInstallData automatedInstallData) {
        this.installdata = automatedInstallData;
        this.leftoperand = condition;
        if (this.leftoperand != null) {
            this.leftoperand.setInstalldata(this.installdata);
        }
        this.rightoperand = condition2;
        if (this.rightoperand != null) {
            this.rightoperand.setInstalldata(this.installdata);
        }
    }

    public void readFromXML(IXMLElement iXMLElement) {
        try {
            if (iXMLElement.getChildrenCount() != 2) {
                Debug.log("and-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(iXMLElement.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(iXMLElement.getChildAtIndex(1));
        }
        catch (Exception exception) {
            Debug.log("missing element in and-condition");
        }
    }

    public boolean isTrue() {
        if (this.leftoperand == null || this.rightoperand == null) {
            Debug.trace("Operands of condition " + this.id + " not initialized correctly.");
            return false;
        }
        this.leftoperand.setInstalldata(this.installdata);
        this.rightoperand.setInstalldata(this.installdata);
        return this.leftoperand.isTrue() && this.rightoperand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on:<ul><li>");
        stringBuffer.append(this.leftoperand.getDependenciesDetails());
        stringBuffer.append("</li> AND <li>");
        stringBuffer.append(this.rightoperand.getDependenciesDetails());
        stringBuffer.append("</li></ul>");
        return stringBuffer.toString();
    }

    public void makeXMLData(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = RulesEngine.createConditionElement(this.leftoperand, iXMLElement);
        this.leftoperand.makeXMLData(iXMLElement2);
        iXMLElement.addChild(iXMLElement2);
        IXMLElement iXMLElement3 = RulesEngine.createConditionElement(this.rightoperand, iXMLElement);
        this.rightoperand.makeXMLData(iXMLElement3);
        iXMLElement.addChild(iXMLElement3);
    }
}

